
<?php 
	
	// GET values from the $_REQUEST global variable
	//
	$agencyName = $_REQUEST['agencyfname'];
	$agencyShortName = $_REQUEST['agencysname'];
	$agencySubDomain = $_REQUEST['agencysubdomain'];
	$agencyAdminEmail = $_REQUEST['agencyadminemail'];
	$corporationID = generateCorporationID();
	
	if ( ! $onboardError ) { 
	
		// Set the path to the script
		$script = '/home/ec2-user/setup.sh';
		
		// Run the script as apache user using sudo
		$output = shell_exec('sudo -u root ' . escapeshellcmd($script) . ' ' . escapeshellarg($agencySubDomain) . ' ' . escapeshellarg($agencyAdminEmail) . ' 2>&1');
	
		// Check the exit status
		$exitCode = shell_exec('echo $?'); // Get the exit code of the last command executed
		
		// Output the result
		if ($exitCode != 0) {
			$onboardingMessage =  "Onboarding for " . $agencyName . " failed to setup domain on the web server.";
			echo "Error: " . $output;
			$onboardError = true;
		} 
		else {
		
			echo "Passed shell_exec" . PHP_EOL;
			
			//  Generate values for DB_NAME, DB_USER and DB_PASS
			//
			$DB_HOST = $_ENV['MAIN_DB_HOST'];
			$DB_NAME = 'ltsscish_' . strtolower( trim($agencyShortName) ) . '_database';
			$DB_USER = 'ltsscish_' . strtolower( trim($agencyShortName) ) . '_dbUser';
			$DB_PASS = generateStrongPassword();
			
			
			//  Copy env file to subdomian env file
		
			$source = ''. $_SERVER['DOCUMENT_ROOT'] . '/assets/PHPDotEnv/' . '.env';
			$destination = ''. $_SERVER['DOCUMENT_ROOT'] . '/assets/PHPDotEnv/.' . trim($agencySubDomain) . '.env';
			
			if ( !copy($source, $destination)) {
		
				$onboardingMessage =  "Onboarding for " . $agencyName . " failed to copy and update .env file.";
				$onboardError = true;
			}
			else {
				// Append required information to the .env file
				
				$fileHandle = fopen($destination, 'a'); // Open the file for appending
		
				if ( !$fileHandle) {
					$onboardingMessage =  "Onboarding for " . $agencyName . " failed to update .env file check with admin.";
					$onboardError = true;
				}
				else {
				
					fwrite($fileHandle, 'CORPORATION_ID='.$corporationID . PHP_EOL);
					fwrite($fileHandle, 'DB_HOST='.$DB_HOST . PHP_EOL);
					fwrite($fileHandle, 'DB_NAME='.$DB_NAME . PHP_EOL);
					fwrite($fileHandle, 'DB_USER='.$DB_USER . PHP_EOL);
					fwrite($fileHandle, 'DB_PASS='.$DB_PASS . PHP_EOL);
					fwrite($fileHandle, 'GOOGLE_API_KEY=' . PHP_EOL);
					fwrite($fileHandle, 'AGENCY_NAME='.$agencyName . PHP_EOL);
					fwrite($fileHandle, 'AGENCY_SHORT_NAME='.$agencyShortName . PHP_EOL);
					fwrite($fileHandle, 'AGENCY_DOMAIN='.$agencySubDomain . PHP_EOL);
					fclose($fileHandle); // close the file after writing
					
					echo "ENV file created" . PHP_EOL;
					
					// Create connection (without specifying database)
					$dbHandle = new mysqli($_ENV['MAIN_DB_HOST'], $_ENV['MAIN_DB_USER'], $_ENV['MAIN_DB_PASS'], $_ENV['MAIN_SYSTEM_DB'] );
								
					// Check connection
					if ($dbHandle->connect_error) {
						$onboardingMessage =  "Onboarding for " . $agencyName . " failed to connect to the database server.";
						echo "Connection failed: " . $dbHandle->connect_error . "\n";
						$onboardError = true;
					}
								
					$sql_create_db = "CREATE DATABASE IF NOT EXISTS $DB_NAME";
					if ( !($dbHandle->query($sql_create_db) === TRUE)) {
						$onboardingMessage =  "Onboarding for " . $agencyName . " failed to create database ( " . $DB_NAME . " ).";
						echo "Error creating database: " . $dbHandle->error . "\n";
						$onboardError = true;
					} 
					else {
						
						$onboardError = false;
						echo "Database created" . PHP_EOL;
						
						/*
						exec('mysqldump --user=' . $_ENV['MAIN_DB_USER'] . '--password=' . $_ENV['MAIN_DB_PASS'] . ' --host=' . $_ENV['MAIN_DB_HOST'] . ' ' . $_ENV['MAIN_SHELL_DB'] . ' > /var/www/html/dbfile.sql', $output, $returnCode );
						
						if ( $returnCode == 0 ) {

							echo "Database dumped" . PHP_EOL;
							exec('mysql --user=' . $_ENV['MAIN_DB_USER'] . '--password=' . $_ENV['MAIN_DB_PASS'] . ' --host=' . $_ENV['MAIN_DB_HOST'] . ' ' . $_ENV['MAIN_SHELL_DB'] . ' < /var/www/html/dbfile.sql', $output, $returnCode );
							
							if ( $returnCode == 0 ) {
								// Create a new database user with a password
								echo "Database Loaded" . PHP_EOL;
								$sql_create_user = "CREATE USER '$DB_USER'@'DB_HOST' IDENTIFIED BY '$DB_PASS'";
							}
							else {
								$onboardingMessage =  "Onboarding for " . $agencyName . " failed to populate ( " . $DB_NAME . " ) database.";
								$onboardError = true;
							}
						}
						else {
							$onboardingMessage =  "Onboarding for " . $agencyName . " failed to populate ( " . $DB_NAME . " ) database.";
							$onboardError = true;
						}
						*/
						
						if ( $onboardError === TRUE ) {
						}
						else if ( !($dbHandle->query($sql_create_user) === TRUE) ) {
							$onboardingMessage =  "Onboarding for " . $agencyName . " failed to create user ( " . $DB_USER . " ).";
							echo "Error creating user: " . $dbHandle->error . "\n";
							$onboardError = true;
						} 
						else {
						
							// Grant permissions to the user on the new database
							$sql_grant_permissions = "GRANT ALL PRIVILEGES ON $DB_NAME.* TO '$DB_USER'@'DB_HOST'";
							if ( !($dbHandle->query($sql_grant_permissions) === TRUE) ) {
								$onboardingMessage =  "Onboarding for " . $agencyName . " failed to grant privileges to user ( " . $DB_USER . " ).";
								echo "Error granting user privileges: " . $dbHandle->error . "\n";
								$onboardError = true;
							} 
							else {
							
								// Apply the changes
								$sql_flush_privileges = "FLUSH PRIVILEGES";
								if ( !($dbHandle->query($sql_flush_privileges) ) === TRUE) {
									$onboardingMessage =  "Onboarding for " . $agencyName . " failed to flush privileges to user ( " . $DB_USER . " ).";
									echo "Error flushing user privileges: " . $dbHandle->error . "\n";
									$onboardError = true;
								} 
							}
						}
					}
				
					// Get date from staging database
					//
					// Output file
					$dbDumpFile = 'backup.sql';
					$file = fopen($outputFile, 'w');
					
					if (!$file) {
						die("Error: Unable to create backup file.");
						$onboardingMessage =  "Onboarding for " . $agencyName . " failed to backup staging databsse ( " . $_ENV['MAIN_SYSTEM_DB'] . " ).";
						$onboardError = true;
					}

					// Get the list of tables
					$result = $dbHandle->query("SHOW TABLES");
					if (!$result) {
						$onboardingMessage =  "Onboarding for " . $agencyName . " failed with error: ( " . $dbHandle->error . " ).";
						$onboardError = true;
						fclose($file);
					}

					while ($row = $result->fetch_array()) {
						$table = $row[0];
					
						// Write CREATE TABLE statement
						$createTableResult = $dbHandle->query("SHOW CREATE TABLE `$table`");
						$createTableRow = $createTableResult->fetch_assoc();
						fwrite($file, $createTableRow['Create Table'] . ";\n\n");
					
						// Dump table data
						$dataResult = $dbHandle->query("SELECT * FROM `$table`");
						while ($dataRow = $dataResult->fetch_assoc()) {
							$columns = array_keys($dataRow);
							$values = array_map([$dbHandle, 'real_escape_string'], array_values($dataRow));
					
							$columnsList = implode('`, `', $columns);
							$valuesList = implode("', '", $values);
					
							$insertStatement = "INSERT INTO `$table` (`$columnsList`) VALUES ('$valuesList');\n";
							fwrite($file, $insertStatement);
						}
					
						fwrite($file, "\n");
					}
					
					// Close file and connection
					fclose($file);

					// Close the connection
					$dbHandle->close();
					
					
					// Dump data to new database
					//
					
					// Connect to the target database
					$dbHandle = new mysqli($_ENV['MAIN_DB_HOST'], $_ENV['MAIN_DB_USER'], $_ENV['MAIN_DB_PASS'], $DB_NAME );
					
					// Check connection
					if ($dbHandle->connect_error) {
						$onboardingMessage =  "Onboarding for " . $agencyName . " failed with error: ( " . $dbHandle->connect_error . " ).";
						$onboardError = true;
					}
					
					// Read the SQL dump file
					$sql = file_get_contents($dbDumpFile);
					
					if ($dbHandle->multi_query($sql)) {
						do {
							// Keep processing results until all queries are done
							if ($result = $dbHandle->store_result()) {
								$result->free();
							}
						} while ($dbHandle->next_result());
						
					} else {
						$onboardingMessage =  "Onboarding for " . $agencyName . " failed. Error importing database: ( " . $dbHandle->error . " ).";
						$onboardError = true;
					}
					
					$dbHandle->close();

					// Write agency configuration data to config databaseclear
					
					//
					if ( !($onboardError === TRUE) ) {
						// Create connection (without specifying database)
						$dbHandle = new mysqli($_ENV['MAIN_DB_HOST'], $_ENV['MAIN_DB_USER'], $_ENV['MAIN_DB_PASS'], $_ENV['MAIN_DB_CONFIG'] );
						if ( $dbHandle->connect_error ) {
							$onboardError = true;
						}
						
						if ( !( $onboardError === TRUE ) ) 
						{
							// Grant permissions to the user on the new database
							$sql_ins_config = "INSERT INTO `CorporationConfig`(`CroporationName`, `CorporationID`, `CorporationDomain`, `";
							$sql_ins_config .= "  CorporationDB`, `CorporationDBUser`, `CorporationDBPass`) VALUES ( ";
							$sql_ins_config .= "'" . $agencyShortName . "', '" . $corporationID . "', '" . $agencySubDomain . "', '" . $DB_NAME . "', '" . $DB_USER . "', '" . $DB_PASS . "')";
							if ( !($dbHandle->query($sql_ins_config) === TRUE) ) {
								$onboardError = true;
							}
						}
								
						// Check connection
						if ( $onboardError === TRUE ) {
							$onboardingMessage =  "Onboarding for " . $agencyName . " is not complete. Please contact support to enter the following Agency Information in the config database." . PHP_EOL . "CorporationName = $agencyShortName" . PHP_EOL . ", CorporationID = $corporationID" . PHP_EOL . ", CorporationDomain = $agencySubDomain" . PHP_EOL . ", CorporationDB = $DB_NAME" . PHP_EOL . ", CorporationDBUser = $DB_USER" . PHP_EOL . ", CorporationDBPass = $DB_PASS" . PHP_EOL;  
							echo "Connection failed: " . $dbHandle->connect_error . "\n";
							$onboardError = true;
						}
					}
					
					// Close the connection
					$dbHandle->close();
					
				} 
			}
		}
	}
	
?>

